"To bitter business bound" by "Victor Gijsbers"

Section - Inclusions

Include Plurality by Emily Short.
[Include Dice-lock by S John Ross.]
Include Basic Screen Effects by Emily Short.

Include Conversation Package by Eric Eve.

[Before doing anything: lock the dice.]

When play begins:
	change the library message person to first person.


Section - Constants

Use full-length room descriptions.

Use MAX_OBJ_PROP_COUNT of 128. [Because we define way more than 64  properties for persons/monsters!]
[Use MAX_PROP_TABLE_SIZE of 50000.]

Use MAX_STATIC_DATA of 300000.
[Use dynamic memory allocation of at least 30000.]

[Use Default Forbid Exiting Conversations. [Simple Chat]]


When play begins, seed the random-number generator with 3581.


To decide which number is the current_row: (- ct_1 -).





[==================================================]


Volume - Inform ATTACK - Main System

Include Custom Library Messages by David Fisher.

[The Main System covers the basics of combat, and creates rulebooks for all other systems to fit into.]


Book - Minor Preliminaries


Chapter - Saying things

[This variable determines whether we get to see numerical output.]

The numbers boolean is a truth state that varies. The numbers boolean is usually true.

Switching the numbers off is an action out of world. Understand "numbers off" as switching the numbers off.

Carry out switching the numbers off:
	now the numbers boolean is false;
	say "You will no longer see combat-related numbers.".

Switching the numbers on is an action out of world. Understand "numbers on" as switching the numbers on.

Carry out switching the numbers on:
	now the numbers boolean is true;
	say "You will now see combat-related numbers.".



[These two phrases are used to refer to the Health score. Change them to rename the Health score.]

To say capital health:
	say "Health".

To say health:
	say "health".


[I want "you", not "yourself".]

[Rule for printing the name of yourself:
	say "you".]

[But we'll need to have tokens that print "You" rather than "you". For this reason, the following.]

To say CAP-attacker:
	if the global attacker is the player begin;
		say "[You]" in sentence case;
	otherwise;
		say "[The global attacker]";
	end if.

To say CAP-defender:
	if the global defender is the player begin;
		say "[You]" in sentence case;
	otherwise;
		say "[The global defender]";
	end if.

The global actor is a person that varies.

To say CAP-actor:
	if the global actor is the player begin;
		say "[You]" in sentence case;
	otherwise;
		say "[The global actor]";
	end if.

To say CAP-noun:
	if the noun is the player begin;
		say "[You]" in sentence case;
	otherwise;
		say "[The noun]";
	end if.

To say CAP-second noun:
	if the second noun is the player begin;
		say "[You]" in sentence case;
	otherwise;
		say "[The second noun]";
	end if.

To say the global defender dobj:
	if the global defender is the player:
		say "[you dobj]";
	otherwise:
		say "[the global defender]".

To say the global defender sub:
	if the global defender is the player:
		say "[you]";
	otherwise:
		say "[the global defender]".

To say the global attacker dobj:
	if the global attacker is the player:
		say "[you dobj]";
	otherwise:
		say "[the global attacker]".

To say the global attacker sub:
	if the global attacker is the player:
		say "[you]";
	otherwise:
		say "[the global attacker]".



Chapter - Global variables


The first dummy, the second dummy, the third dummy and the fourth dummy are numbers that vary.



Chapter - Time

[Some of the actions should take no time; we wish to ensure that examining, smelling, and so on do not take a combat turn. This will allow the player to look around in combat, which is to be encouraged.]

Examining something is acting fast.
Taking inventory is acting fast.
Smelling is acting fast.
Smelling something is acting fast.
Looking is acting fast.
Looking under something is acting fast.
Listening is acting fast.
Listening to something is acting fast.
Thinking is acting fast.


First turn sequence rule: if acting fast, rule succeeds.

To take no time:
    (- meta = true; -).




Book - Dressing up the Person Class

Chapter - Health

A person has a number called health. The health of a person is usually 10. [health is a measure of health.]

Definition: A person is alive if its health is 1 or more. Definition: A person is killed if its health is 0 or less. [Once health drops to zero, you are dead. This holds true for both the player and his enemies.] 

[Understand the alive property as describing a monster.]

Instead of taking a killed person:
	say "[You] [doesn't|don't] want to carry that around.".

A person has a number called permanent health. [The maximum you can regain with healing.]

When play begins:
    repeat with the patient running through people begin;
        change the permanent health of the patient to the health of the patient;
    end repeat.

[We set the permanent health of each individual to the health it has at the beginning of the game. If we wish any character to start the game wounded or super-healthy, we will have to manually override this process.]

To restore the health of (patient - a person): change the health of the patient to the permanent health of the patient. 

To heal (patient - a person) for (health - a number) health:
	let the health dummy be the permanent health of the patient minus the health of the patient;
	if health is less than the first dummy, now the health dummy is health;
	increase the health of the patient by the health dummy;
	say the health dummy.


A person has a number called gained health. [This is the amount of health the player will get when killing the character.]

When play begins:
	repeat with the patient running through people begin;
        	change the gained health of the patient to a random number between 1 and the permanent health of the patient;
[		if the patient is summoned, now the gained health of the patient is 0; ]
	end repeat.


Chapter - Basic Combat Stats

[Melee is a measure of fighting prowess. Higher melee means higher chance to hit.]

A person has a number called melee. The melee of a person is usually 0. 

[Defence is a measure of fighting prowess. Higher defence means less chance to get hit.]

A person has a number called defence. The defence of a person is usually 7.

[Damage die is the virtual die-size that we roll with when seeing how much damage a person does. If the die size is 4, the person does between 1 and 4 damage; if 8, between 1 and 8 damage; and so on.]

A person has a number called damage die. The damage die of a person is usually 6.


Chapter - Hostility

Hostility is a kind of value. The hostilities are neutral, friendly, hostile, hostile_2, hostile_3, hostile_4.

[A non-combatant should be neutral: he does not attack and does not defend. The player should be friendly, and so should his allies. Monsters should be hostile. Hostile_2, hostile_3 and hostile_4 allow for monsters that fight amongst each other and fight the player.]

A person has a hostility. The hostility of a person is usually neutral.

The hostility of the player is friendly.


Chapter - Monster

A monster is a kind of person. The hostility of a monster is usually hostile.



Book - Combat Round Preliminaries

Chapter - The pressing relation

[Pressing is mostly just a way to remember who had been attacking whom. The AI prefers continuing to attack the same person. You also get an initiative penalty for being pressed by many people.]

Pressing relates various people to various people. The verb to press (he presses, they press, he pressed, it is pressed, he is pressing) implies the pressing relation.

[This routine takes care of the pressing relations]

To have (A - a person) start pressing (B - a person):
	repeat with X running through all persons pressed by A:
		now A does not press X;
	now A presses B.

Chapter - Initiative

[The initiative modifier influences how early in the combat round someone can take an action.]

A person has a number called the initiative modifier. The initiative modifier of a person is usually 0.

An aftereffects rule (this is the modify initiative based on combat results rule):
	if the final damage is greater than 0 begin;
		decrease the initiative modifier of the global defender by the final damage;
	otherwise;
		decrease the initiative modifier of the global attacker by 2;
	end if.

 Carry out an actor waiting:
	increase the initiative modifier of the actor by 2.
	

Chapter - Combat States

[A person can have three combat states: None, Acted, React. These have the following meanings:

None: the person still has to get a turn, and can do anything when the turn comes.
Acted: the person has already taken a turn.
React: the person must act now.]

Combat state is a kind of value. The combat states are None, Acted and React.

A person has a combat state. The combat state of a person is usually None.

[A person can have three react states: NoReact, Defensive and Aggressive.

Defensive: the person did something like dodge or parry when he had to react; this gives a bonus.
Aggressive: the person counterattacked when he had to react; this increases risk.]

React state is a kind of value. The react states are No React, Defensive and Aggressive.

A person has a react state. The react state of a person is usually No React.

An always-present attack modifiers rule (this is the defensive move bonus rule):
	if the react state of the global defender is defensive begin;
		if the numbers boolean is true, say " - 1 (defensive move)[run paragraph on]";
		decrease the to-hit modifier by 1;
		now the react state of the global defender is No React;
	end if.

A damage modifiers rule (this is the counterattack extra damage rule):
	if the react state of the global attacker is aggressive or the react state of the global defender is aggressive begin;
		if the numbers boolean is true, say " + 3 (both attacking)[run paragraph on]";
		increase the damage modifier by 3;
		now the react state of the global attacker is No React;
		now the react state of the global defender is No React;
	end if.

[A person has a number called the combat move bonus. This ]


Book - The Combat Round

[The main thing here is to: (1) decide in which order people can go; (2) call everyone's AI in order to make them do something; (3) calculate the preliminary results of each action and store all future actions; (4) once everyone has had their turn, go through the stored actions.]

Chapter - Setting up the Combat Round

[(1) decide in which order people can go.]

When play begins (this is the first combat round rule):
	set up the combat order.

Last turn sequence rule (this is the begin the combat round rule):
	set up the combat order.

Table of Combat Order
Combatant	       Move Order
a person			a number
with 50 blank rows

To set up the combat order:
	repeat through the Table of Combat Order:
		blank out the whole row;
	repeat with X running through all alive not neutral persons enclosed by the location:
		choose a blank row in Table of Combat Order;
		now the Combatant entry is X;
		[say "[X]: "; [Test]]
		now the Move Order entry is the number of persons pressing X;
		[say "[Move Order entry]"; [Test]]
		decrease the Move Order entry by the initiative modifier of X;
		[say "[Move Order entry]"; [Test]]
		increase the Move Order entry by a random number between 1 and 3;
		[say "[Move Order entry]"; [Test]]
		now the combat state of X is None;
		now the react state of X is No React;
		now the initiative modifier of X is 0;
	sort the Table of Combat Order in random order;
	sort the Table of Combat Order in Move Order order.

Chapter - Taking Actions (part I)

[This is slightly tricky, since we have to do part of this before, and part of it after the player has taken a turn. So we start running through the list until we get to the player, then stop.]

Last turn sequence rule:
	[say "=== NEW ROUND ==="; [Test.]]
	repeat with M running from 1 to the number of rows in the Table of Combat Order:
		if there is a combatant in row M of the Table of Combat Order:
			choose row M in the Table of Combat Order;
			if the combatant entry is the player, stop;
			unless the combat state of the combatant entry is Acted:
				now the global attacker is the combatant entry;
				if the global attacker is alive, consider the combat AI rulebook of the global attacker;
				now the combat state of the combatant entry is Acted;
				if the combat state of the player is React, stop;
				while there are reactionaries, have a reaction;
				run the combat.


Section - Reacting

To decide whether there are reactionaries:
	repeat with X running through alive persons enclosed by the location begin;
		if X is neutral, now the combat state of X is Acted; [Neutral people cannot attack; this line prevents lockups.]
		if the combat state of X is React, decide yes;
	end repeat;
	decide no.

To have a reaction:
	repeat with N running from 1 to the number of rows in the Table of Combat Order:
		choose row N in the Table of Combat Order;
		if there is combatant in row N of the Table of Combat Order:
			if the combat state of the combatant entry is React:
				now the global attacker is the combatant entry;
				if the global attacker is the player:
					stop;
				if the global attacker is alive, consider the combat AI rulebook of the global attacker;
				now the combat state of the global attacker is Acted.


Chapter - Taking Actions (part II)

[Now we go on until everybody has acted.]

Every turn: 
	now the combat state of the player is acted;
	now the global attacker is the player;
	while there are reactionaries, have a reaction;
	run the combat;
	repeat with M running from 1 to the number of rows in the Table of Combat Order:
		if there is a combatant in row M of the Table of Combat Order:
			choose row M in the Table of Combat Order;
			unless the combat state of the combatant entry is Acted:
				now the global attacker is the combatant entry;
				if the global attacker is alive, consider the combat AI rulebook of the global attacker;
				now the combat state of the combatant entry is Acted;
				while there are reactionaries, have a reaction;
				run the combat.



Chapter - Run the Combat

The fight consequences variable is a truth state that varies. The fight consequences variable is false.

Table of Stored Combat Actions
Combat Speed		Combat Action
a number				a stored action
with 50 blank rows

To run the combat:
	now the fight consequences variable is true;
	sort the Table of Stored Combat Actions in Combat Speed order;
	repeat through the Table of Stored Combat Actions:
		try the Combat Action entry;
		blank out the whole row;
	now the fight consequences variable is false.




Book - Striking a Blow



Chapter - Striking a blow

The global attacker is a person that varies.
The global defender is a person that varies.

A weapon is a kind of thing. A weapon is either readied or not readied. A weapon is usually not readied.

The global attacker weapon is a weapon that varies.
The global defender weapon is a weapon that varies.

The to-hit roll is a number that varies. The to-hit modifier is a number that varies. The damage is a number that varies. The damage modifier is a number that varies. The final damage is a number that varies.

The global flavour text boolean is a truth state that varies. The global flavour text boolean is usually false.

The reset combat variables is a rulebook.
The whether attacking begins is a rulebook.
The preliminary results of attacking is a rulebook.
The basic attack roll is a rulebook.
The whether attack modifiers apply is a rulebook.
The attack modifiers is a rulebook.
The always-present attack modifiers is a rulebook.
The show results of the attack roll is a rulebook.
The whether the attack hit is a rulebook.
The immediate results of hitting is a rulebook.
The basic damage roll is a rulebook.
The damage modifiers is a rulebook.
[The always-present damage modifiers is a rulebook.]
The printing-the-damage is a rulebook.
The final damage rules is a rulebook.
The report no final damage is a rulebook.
The non-fatal damage is a rulebook.
The fatal damage is a rulebook.
The take away until attack bonuses is a rulebook.
The print flavour text is a rulebook.
The aftereffects is a rulebook.
The final blow report is a rulebook.

To make (attacker - a person) strike a blow against (defender - a person):
	now the global attacker is the attacker;
	now the global defender is the defender;
	have the global attacker start pressing the global defender;
	now the global attacker weapon is a random readied weapon enclosed by the global attacker;
	now the global defender weapon is a random readied weapon enclosed by the global defender;
	consider the reset combat variables rules;
	abide by the whether attacking begins rules; [Stage 1: Whether attacking begins]
	consider the preliminary results of attacking rules; [Stage 2: Preliminary results of attacking]
	consider the basic attack roll rules; [Stage 3: Basic attack roll]
	consider the whether attack modifiers apply rules; [Stage 4: Do attack modifiers apply?]
	if rule succeeded, consider the attack modifiers rules;[Stage 5: Apply attack modifiers]
	consider the always-present attack modifiers rules; [Stage 6: Apply attack modifiers that always apply, for instance even when getting a free bonus attack from the cleave ability]
	consider the show results of the attack roll rules; [Stage 7: show results of the attack roll]
	consider the whether the attack hit rules; [Stage 8: check and report whether we hit]
	if rule succeeded begin;
		consider the immediate results of hitting rules; [Stage 9: stage for some special effects]
		consider the basic damage roll rules; [Stage 10: roll the die for damage]
		consider the damage modifiers rules; [Stage 11: add or subtract modifiers]
[		consider the always-present damage modifiers rules;] [Probably useless]
		if the damage is greater than 0, consider the final damage rules; [Stage 12: calculate final damage]
		consider the printing-the-damage rules; [Stage 13: print the damage]
		if the final damage is 0, consider the report no final damage rules; [Stage 14: report no damage]
		if the final damage is greater than 0 begin;
			if the final damage is less than the health of the global defender begin;
				consider the non-fatal damage rules; [Stage 14: report and apply non-fatal damage]
			otherwise;
				consider the fatal damage rules; [Stage 14: report and apply fatal damage]
			end if;
		end if;
	end if;
	consider the print flavour text rules; [Stage 15: flavour text]
	if the player is not killed, consider the aftereffects rulebook; [Stage 16: aftereffects]
	consider the take away until attack bonuses rulebook;
	consider the final blow report rulebook. [Stage 17: any reporting left to be done]


Section - Reset combat variables

A reset combat variables rule (this is the standard reset combat variables rule):
	now the damage is 0; 
	now the final damage is 0;
	now the to-hit roll is 0;
	now the to-hit modifier is 0;
	now the damage modifier is 0.


Section - Basic attack roll

A basic attack roll rule (this is the standard attack roll rule):
	if the numbers boolean is true, say "[italic type]Rolling ";
	change the to-hit roll to a random number between 1 and 10;
	if the numbers boolean is true, say the to-hit roll, "[run paragraph on]".


Section - Whether attack modifiers apply

A whether attack modifiers apply rule (this is the attack modifiers apply unless something intervenes rule):
	rule succeeds.


Section - Attack modifier melee

An attack modifiers rule (this is the melee attack bonus rule):
		if the numbers boolean is true begin;
			if the melee of the global attacker is greater than 0, say " + ", the melee of the global attacker, "[run paragraph on]";
			let n be 0 - the melee of the global attacker;
			if n is greater than 0, say " - ", n, "[run paragraph on]";
		end if;
		increase the to-hit modifier by the melee of the global attacker.


Section - Show results of attack roll

A show results of the attack roll rule (this is the standard result of the attack roll rule):
	increase the to-hit roll by the to-hit modifier;
	if the numbers boolean is true, say " = ", the to-hit roll, ", [run paragraph on]";


Section - Whether the attack hits

A whether the attack hit rule (this is the standard whether the attack hit rule):
	if the to-hit roll is greater than the defence of the global defender begin;
		if the numbers boolean is true begin;
			if the global attacker is the player, say "you beat "; otherwise say "[the global attacker] beats ";
			say "[possessive of global defender] defence rating of ", the defence of the global defender, ".";
		end if;
		rule succeeds;
	otherwise;
		if the numbers boolean is true begin;
			if the global attacker is the player, say "you do ";
			if the global attacker is not the player, say "[the global attacker] does ";
			say "not overcome [possessive of global defender] defence rating of ", the defence of the global defender, ".[run paragraph on]";
		end if;
		rule fails;
	end if.

Section - Basic damage roll

First basic damage roll rule (this is the standard damage roll rule):
	now the damage is a random number between 1 and the damage die of the global attacker weapon;
	if the numbers boolean is true begin;
		if the global attacker is the player, say "You deal ", damage, "[run paragraph on]";
		if the global attacker is not the player, say "[The global attacker] deals ", damage, "[run paragraph on]";
	end if.


Section - Final damage

Final damage rule (this is the basic final damage rule):
	now the final damage is the damage plus the damage modifier.


Section - Printing the damage

Printing-the-damage rule (this is the standard printing-the-damage rule):
	if the numbers boolean is true, say " = [bold type]", final damage, " damage[roman type][italic type], [run paragraph on]".



Section - Report no final damage

Report no final damage rule (this is the basic no final damage rule):
	if the numbers boolean is true begin;
		if the global defender is not the player, say "allowing [the global defender] to escape unscathed.[run paragraph on]";
		if the global defender is the player, say "allowing you to escape unscathed.[run paragraph on]";
	end if.


Section - Print flavour text

First print flavour text rule:
	if the numbers boolean is true, say "[roman type][paragraph break]".

[
Print flavour text rule (this is the basic print flavour text rule):
	say "[roman type]";
	if the global attacker is the player or the global defender is the player begin; [We only print flavour text when it's not monster vs monster, because writing appropriate texts for all monster vs monster interactions is a quadratic rather than a linear task.]
		say "[paragraph break]"; [Here we start printing the flavour text.]
		now the global flavour text boolean is true; [To ensure that (killed) is not printed.]
		if the global attacker is the player begin;
			[choose a random row from the Player Flavour Texts of the defender;]
		otherwise;
			[if the defender is the player, choose a random row from the Monster Flavour Texts of the attacker;]
		end if;
		if the global defender is killed begin;
			[if the defender is not boss, say "[Fatal Text entry]";]
		otherwise;
			[if the to-hit roll is not greater than the defence of the defender, say "[Miss Text entry]";]
			[if the to-hit roll is greater than the defence of the defender begin;
				if the final damage is greater than 0, say "[Hit Text entry]";
				if the final damage is 0, say "[Absorbed Text entry]";
			end if;]
		end if;
	end if; 
	now the global flavour text boolean is false.
]

Section - Final blow report

[Final blow report rule (this is the insert a paragraph break when needed after reporting a blow rule):
	if the global defender is not killed [or the defender is not boss], say "[paragraph break]". [Killing and boss give paragraph breaks of their own.]]

Last final blow report rule (this is the end reporting blow with paragraph break rule):
	say "[paragraph break]".





Chapter - Calculating damage

[First damage modifiers rule (this is the temp rule):
	if the cleave boolean is false begin; [No extra attack bonus when cleaving]
		if the attack state is not fiery begin; [Things that do not work with touch attacks]
			say ""; [Currently useless! Have to think about it.]
		end if;
		if the damage bonus of the global attacker is not 0 begin;
			increase the damage modifier by the damage bonus of the global attacker;
			say " + ", damage bonus of the global attacker, " (inherent damage bonus)";
		end if;
		if the deadly combat bonus is not 0 begin;
			increase the damage modifier by the deadly combat bonus;
			if the deadlier combat boolean is true, increase the damage modifier by the deadly combat bonus;
			if the deadlier combat boolean is false, say " + ", deadly combat bonus, " (deadly combat)";
			if the deadlier combat boolean is true, say " + ", 2 times the deadly combat bonus, " (deadlier combat)";
		end if;
		if the beat is not 0 and the beat count is 0 and the beat strength is not 0 begin;
			increase the damage modifier by the beat strength;
			say " + ", beat strength, " (beat)";
		end if;
		calculate the excitement damage bonus of the global attacker;
		if the sacrificial number of the global attacker is greater than 0 begin;
			say " + ", the sacrificial number of the global attacker, " (sacrifice)";
			increase the damage modifier by the sacrificial number of the global attacker;
			now the sacrificial number of the global attacker is 0;
		end if;
		if the damage await bonus is greater than 0 and the global attacker is the player begin;
				say " + ", the damage await bonus, " (awaiting)";
				increase the damage modifier by the damage await bonus;
		end if;
		if the global attacker is smashing, do smashing blow with global attacker and global defender;  [Smashing blow]
	end if;
	if the cleave boolean is true begin;
		if the cleave damage bonus is greater than 0, say " + ", the cleave damage bonus, " (cleave)";
		increase the damage modifier by the cleave damage bonus;
	end if;
	if the damage reduction of the global defender is not 0 begin;
		say " - ", the damage reduction of the global defender, " (inherent damage reduction)";
		decrease the damage modifier by the damage reduction of the global defender;
	end if;
	increase the damage by the damage modifier;
	say " = [bold type]", damage, "[italic type]";
	continue the activity.]



Chapter - Calculating the final damage

[Last final damage rule (this is the damage turns of deadly combat rule):
	if the final damage is greater than 0, now the deadly combat boolean is false.]


To calculate the final damage (attacker - a person) does against (defender - a person):
    [if the elda armour status of the defender is greater than 0, do elda armour with attacker and defender;]
    continue the activity.


Chapter - Non-fatal damage

Non-fatal damage rule (this is the basic non-fatal damage rule):
	decrease the health of the global defender by the final damage;
	if the numbers boolean is true begin;
		if the global defender is not the player, say "wounding [the global defender] to ", health of the global defender, " health.[run paragraph on]" ;
		if the global defender is the player, say "wounding you to ", health of the global defender, " health.[run paragraph on]";
	end if;
	[if the attacker is the player and the defender is not non-exciting and a random chance of 1 in 20 succeeds, increase the excitement of the player;]
	[if the defender is the player and the attacker is not non-exciting and a random chance of 1 in 15 succeeds, increase the excitement of the player;].


Chapter - Fatal damage

Fatal damage rule (this is the basic fatal damage rule):
	decrease the health of the global defender by the final damage;
	if the global defender is not the player begin;
		if the numbers boolean is true, say "killing [the global defender].[run paragraph on]";
		[receive health for the global defender;]
		[if the global defender is not non-exciting and a random chance of 2 in 3 succeeds, increase the excitement of the player;]
		[if a random chance of 1 in 3 succeeds and the global defender is not non-exciting, increase the excitement of the player;]
		[now the cleave melee bonus is the to-hit roll minus the defence of the global defender;]
		[now the cleave damage bonus is 0 minus the health of the global defender;]
	end if;
	if the global defender is the player begin;
		if the numbers boolean is true, say "killing you.";
	end if.



Chapter - Receiving health after a kill

To receive health for (the victim - a person):
	now the third dummy is the permanent health of the player - the health of the player;
	now the fourth dummy is the gained health of the victim;
	if the fourth dummy is greater than the third dummy, now the fourth dummy is the third dummy;
	if the fourth dummy is greater than 0 begin;
		if the numbers boolean is true, say " [bold type](Your health increases by ", the fourth dummy;
		increase the health of the player by the fourth dummy;
		[if the beat is not 0 and the beat count is 0 and the beat strength is not 0 and the health of the player is not the permanent health of the player begin;
			now the fourth dummy is the beat strength;
			now the third dummy is the permanent health of the player - the health of the player;
			if the fourth dummy is greater than the third dummy, now the fourth dummy is the third dummy;
			increase the health of the player by the fourth dummy;
			if the fourth dummy is greater than 0, say " + ", fourth dummy, " extra beat bonus";
		end if;]
		if the numbers boolean is true, say ".)[roman type][run paragraph on]";
	end if.





Book - Standard Combat Actions


Chapter - Attacking

The block attacking rule is not listed in any rulebook.

Understand "a [thing]" as attacking.

[Does the player mean attacking a killed monster: it is unlikely.
Does the player mean attacking a hostile alive monster: it is very likely.]

A check attacking rule (this is the do not attack yourself rule):
	if the noun is the player, say "You do not want to attack yourself." instead.

A check attacking rule (this is the only attack persons rule):
	if the noun is not a person, say "Things are not your enemies." instead.

A check attacking rule (this is the only attack the living rule):
	if the noun is not alive, say "[The noun] is already dead." instead.

A check attacking rule (this is the do not attack friendly people rule):
	if the hostility of the noun is friendly, say "[The noun] is your friend, not your enemy!" instead.

A check attacking rule (this is the do not attack neutral people rule):
	if the hostility of the noun is neutral, say "[The noun] is not your enemy." instead.



Carry out an actor attacking when the fight consequences variable is false:
	if the combat state of the actor is React begin;
		now the react state of the actor is aggressive;
		decrease the initiative modifier of the actor by 1;
	end if;
	choose a blank row in the Table of Stored Combat actions;
	now the Combat Speed entry is 10;
	if the combat state of the actor is React begin; [This is a counterattack]
		let n be a random number between 1 and 7;
		now the Combat Speed entry is 5 + n; [Speed between 6 and 12, therefore some chance of going before the attacker, whose speed is 10.]
	end if;
	now the Combat Action entry is the action of the actor attacking the noun;
	if the combat state of the noun is not Acted begin;
		now the combat state of the noun is React;
		consider the attack move flavour rulebook;
	end if.

Carry out an actor attacking when the fight consequences variable is true:
	if the actor is alive, make the actor strike a blow against the noun.



Chapter - Concentrating

Concentrating is an action applying to nothing. Understand "concentrate" and "c" as concentrating.

A person has a number called concentration. The concentration of a person is usually 0.

Carry out an actor concentrating:
	increase the initiative modifier of the actor by 1;
	increase the concentration of the actor by 1;
	if the concentration of the actor is greater than 3, now the concentration of the actor is 3;
	now the global actor is the actor;
	if the concentration of the actor is 1, say "[CAP-actor] concentrate[-s], and [is|are] now mildly concentrated.";
	if the concentration of the actor is 2, say "[CAP-actor] concentrate[-s], and [is|are] now quite concentrated.";
	if the concentration of the actor is 3, say "[CAP-actor] concentrate[-s], and [is|are] now maximally concentrated.".

An attack modifiers rule (this is the concentration attack modifier rule):
	if the concentration of the global attacker is greater than 0 begin;
		if the concentration of the global attacker is 1, now the first dummy is 2;
		if the concentration of the global attacker is 2, now the first dummy is 4;
		if the concentration of the global attacker is 3, now the first dummy is 8;
		[if the global attacker is at parry begin;
			increase the first dummy by the concentration of the global attacker;
			decrease the first dummy by 1; [an additional +0/+1/+2]
		end if;]
		if the numbers boolean is true, say " + ", the first dummy, " (concentration)[run paragraph on]";
		increase the to-hit modifier by the first dummy;
	end if.

A damage modifiers rule (this is the concentration damage modifier rule):
	if the concentration of the global attacker is greater than 1 begin;
		if the concentration of the global attacker is 2, now the first dummy is 2;
		if the concentration of the global attacker is 3, now the first dummy is 4;
[		if the global attacker is at parry, increase the first dummy by 1; [another +1 bonus]]
		if the numbers boolean is true, say " + ", the first dummy, " (concentration)[run paragraph on]";
		increase the damage modifier by the first dummy;
	end if.

[A non-fatal damage rule (this is the lose concentration when hit rule):
	let the global defender lose concentration.]

A take away until attack bonuses rule (this is the lose concentration after attacking rule):
	[if the attack state is not free, ]now the concentration of the global attacker is 0.

An aftereffects rule:
	if the final damage is greater than 0 and the global defender is alive, let the global defender lose concentration.

To let (the defender - a person) lose concentration:
	if the concentration of the defender is 0, continue the activity;
[	if the defender is determined begin;
		now the first dummy is a random number between 1 and 6;
		if the first dummy is not less than the final damage begin;
			say " Because you are so [bold type]determined[roman type], you do not lose your concentration![run paragraph on]";
			continue the activity;
		end if;
	end if;]
	now the concentration of the defender is 0;
	if the defender is the player, say " [You] los[e-s] [your] [bold type]concentration[roman type]![run paragraph on]";
	if the defender is not the player, say " [The defender] loses [bold type]concentration[roman type]![run paragraph on]".

To let (the defender - a person) lose concentration between brackets:
	if the concentration of the defender is 0, continue the activity;
[	if the defender is determined begin;
		now the first dummy is a random number between 1 and 6;
		if the first dummy is not less than the final damage begin;
			say " (not making you lose your concentration, since you are so [bold type]determined[roman type])[run paragraph on]";
			continue the activity;
		end if;
	end if;]
	now the concentration of the defender is 0;
	if the defender is the player, say "(making [you] los[e-s] [your] [bold type]concentration[roman type])[run paragraph on]";
	if the defender is not the player, say "(making [the defender] lose [bold type]concentration[roman type])[run paragraph on]".


[After concentrating:
	if the concentration of the actor is 1 and a random chance of 1 in 4 succeeds, decrease the excitement of the actor;
	if the concentration of the actor is 2 and a random chance of 1 in 3 succeeds, decrease the excitement of the actor;
	if the concentration of the actor is 3 and a random chance of 1 in 2 succeeds, decrease the excitement of the actor]


Chance to win rule (this is the CTW concentration bonus rule):
	if the concentration of the global attacker is 1, increase the chance-to-win by 2;
	if the concentration of the global attacker is 2, increase the chance-to-win by 4;
	if the concentration of the global attacker is 3, increase the chance-to-win by 8.


Chapter - Parrying


Parrying is an action applying to nothing. Understand "parry" and "p" as parrying.

A person can be at parry or not at parry. A person is usually not at parry.

Carry out an actor parrying:
	increase the initiative modifier of the actor by 1;
	if the combat state of the actor is React begin;
		now the react state of the actor is defensive;
		increase the initiative modifier of the actor by 1;
	end if;
	now the actor is at parry;
	now the actor is not at dodge;
	now the global actor is the actor;
	say "[CAP-actor] strike[-s] up a defensive pose.".


An always-present attack modifiers rule (this is the parry decreases to-hit rule):
	if the global defender is at parry begin;
		let n be the passive parry max of global attacker weapon;
		if the active parry max of global defender weapon is less than n, now n is the active parry max of global defender weapon;
		if the numbers boolean is true begin;
			if n is greater than 0, say " - ", n, " (defender parrying)[run paragraph on]";
			if n is 0 and active parry max of global defender weapon is 0 begin;
				say " - 0 (cannot parry with [global defender weapon])[run paragraph on]";
			otherwise;
				if n is 0, say " - 0 (cannot parry against [global attacker weapon])[run paragraph on]";
			end if;
		end if;
		decrease the to-hit modifier by n;
	end if.

[		[if the global defender is not shielded, ]now the first dummy is a random number between 0 and 4;
[		if the global defender is shielded, now the first dummy is a random number between 2 and 6;]
		if the first dummy is not 0, say " - ", first dummy, " (opponent parrying)[run paragraph on]";
		decrease the damage modifier by the first dummy;]



A take away until attack bonuses rule (this is the no longer at parry after attacking rule):
	now the global attacker is not at parry.

Chance to win rule (this is the CTW parry bonus rule):
	if the global defender is at parry begin;
		let n be the passive parry max of global attacker weapon;
		if the active parry max of global defender weapon is less than n, now n is the active parry max of global defender weapon;
		decrease the chance-to-win by n;
	end if.



Chapter - Dodging


Dodging is an action applying to nothing. Understand "dodge" and "do" as dodging.

A person can be at dodge or not at dodge. A person is usually not at dodge.

Carry out an actor dodging:
	increase the initiative modifier of the actor by 1;
	if the combat state of the actor is React, now the react state of the actor is defensive;
	now the actor is at dodge;
	now the actor is not at parry;
	now the global actor is the actor;
	say "[CAP-actor] get[-s] ready for quick evasive maneuvers.".

An always-present attack modifiers rule (this is the dodging defence bonus rule):
	if the global defender is at dodge begin;
		let n be the dodgability of global attacker weapon;
		if the numbers boolean is true begin;
			if n is greater than 0, say " - ", n, " (defender dodging)[run paragraph on]";
			if n is 0, say " - 0 (cannot dodge)[run paragraph on]";
		end if;
		decrease the to-hit modifier by n;
	end if.

An attack modifiers rule (this is the dodging attack bonus rule):
	if the global attacker is at dodge begin;
		if the numbers boolean is true, say " + 1 (dodge bonus)[run paragraph on]";
		increase the to-hit modifier by 1;
	end if.

A take away until attack bonuses rule (this is the no longer at dodge after attacking rule):
	now the global attacker is not at dodge.

Chance to win rule (this is the CTW dodge bonus rule):
	if the global defender is at dodge, decrease the chance-to-win by the dodgability of the stored_weapon.





Book - Artificial Intelligence

[Our standard AI works in two stages. In the first stage, we choose a person to attack--if we were to attack. In the second stage, we decide whether to attack or whether to do something else--like concentrating, dodging, readying a weapon, and so on.]

Chapter - The Tables

Table of AI Combat Person Options
Person Option					Weight
a person						a number
with 100 blank rows

Table of AI Combat Options
Option						Weight
a stored  action				a number
with 100 blank rows

Table of AI Combat Weapon Options
Weapon Option				Weight
a weapon					a number
with 30 blank rows



Section - Blanking out the Tables

To blank out the AI Combat Options:
	repeat through the Table of AI Combat Options:
		blank out the whole row.

To blank out the AI Combat Person Options:
	repeat through the Table of AI Combat Person Options:
		blank out the whole row.

To blank out the AI Combat Weapon Options:
	repeat through the Table of AI Combat Weapon Options:
		blank out the whole row.

Section - Useful variables

Stored_row is a number that varies.

Stored_person is a person that varies.

Stored_weapon is a weapon that varies.

Stored_action is a stored action that varies.


Chapter - First Stage - Choosing a Person

Section - Rulebook

The standard AI target select rules are a rulebook.

The found-a-target boolean is a truth state that varies.

To have the AI select a target:
	blank out the AI Combat Person Options;
	now the found-a-target boolean is false;
	repeat with X running through all alive persons enclosed by the location begin;
		if the hostility of X is not neutral begin;
			if the hostility of X is not the hostility of the global attacker begin;
				now the found-a-target boolean is true;
				choose a blank Row in the Table of AI Combat Person Options;
				change Person Option entry to X;
				change Weight entry to 0;
				now stored_row is the current_row;
				now stored_person is X;
				consider the standard AI target select rules;
				[say "[Person Option entry]: [Weight entry]"; [for testing]]
			end if;
		end if;
	end repeat;
	if the found-a-target boolean is true begin;
		sort the Table of AI Combat Person Options in random order;
		sort the Table of AI Combat Person Options in reverse Weight order;
		choose row one in the Table of AI Combat Person Options;
		now the global defender is the Person Option entry;
	end if.

Section - Standard rules

A standard AI target select rule (this is the prefer targets you press rule):
	choose row stored_row in Table of AI Combat Person Options;
	if the global attacker presses stored_person, increase the Weight entry by 3.

A standard AI target select rule (this is the prefer those who press you rule):
	choose row stored_row in Table of AI Combat Person Options;
	if the stored_person presses the global attacker, increase the Weight entry by 1.

A standard AI target select rule (this is the prefer the player rule):
	choose row stored_row in Table of AI Combat Person Options;
	if the stored_person is the player, increase the Weight entry by 1.

A standard AI target select rule (this is the prefer the severely wounded rule):
	choose row stored_row in Table of AI Combat Person Options;
	if the health of stored_person times 2 is less than the permanent health of stored_person, increase the Weight entry by 2;
	if the health of stored_person times 4 is less than the permanent health of stored_person, increase the Weight entry by 4.

A standard AI target select rule (this is the prefer concentrated people rule):
	choose row stored_row in Table of AI Combat Person Options;
	increase the Weight entry by the concentration of the stored_person;
	if the concentration of the stored_person is 3, increase the Weight entry by 2.

A standard AI target select rule (this is the prefer those with good weapons rule):
	choose row stored_row in Table of AI Combat Person Options;
	let item be a random readied weapon enclosed by the stored_person;
	increase the Weight entry by the damage die of item.

A standard AI target select rule (this is the do not prefer dodgers rule):
	choose row stored_row in Table of AI Combat Person Options;
	let item be a random readied weapon enclosed by the global attacker;
	if the stored_person is at dodge, decrease the Weight entry by the dodgability of item.

A standard AI target select rule (this is the do not prefer parrying rule):
	choose row stored_row in Table of AI Combat Person Options;
	let item be a random readied weapon enclosed by the global attacker;
	let item2 be a random readied weapon enclosed by the stored_person;
	let n be the passive parry max of item;
	if the active parry max of item2 is less than n, now n is the active parry max of item2;
	if the stored_person is at parry, decrease the Weight entry by n.

[The following rule makes the actor prefer people with low defence, unless he is concentrated, in which case he prefers people with high defence. Reason: if you managed to become concentrated, you should use that bonus against otherwise tough opponents.]

A standard AI target select rule (this is the do not prefer high defence unless concentrated rule):
	choose row stored_row in Table of AI Combat Person Options;
	let n be the defence of stored_person minus the melee of the global attacker;
	if n is less than 0, now n is 0;
	let m be the concentration of the global attacker minus 1;
	increase the Weight entry by n times m. [Negative if concentration = 0; 0 is concentration is 1; positive if concentration is 2 or 3.]

A standard AI target select rule (this is the randomise the target result rule):
	choose row stored_row in Table of AI Combat Person Options;
	increase the Weight entry by a random number between 0 and 3.



Chapter - Second Stage - Choosing a Weapon

The standard AI weapon select rules are a rulebook.

To have the AI select a weapon:
	blank out the AI Combat Weapon Options;
	repeat with X running through all weapons enclosed by the global attacker begin;
		choose a blank Row in the Table of AI Combat Weapon Options;
		change Weapon Option entry to X;
		change Weight entry to 0;
		now stored_row is the current_row;
		now stored_weapon is X;
		consider the standard AI weapon select rules;
		[say "[Weapon Option entry]: [Weight entry]"; [for testing]]
	end repeat;
	sort the Table of AI Combat Weapon Options in random order;
	sort the Table of AI Combat Weapon Options in reverse Weight order;
	choose row one in the Table of AI Combat Weapon Options;
	now the stored_weapon is the Weapon Option entry. 


Section - Standard rules

A standard AI weapon select rule (this is the prefer lots of damage rule):
	choose row stored_row in Table of AI Combat Weapon Options;
	increase the Weight entry by the damage die of the Weapon Option entry.

A standard AI weapon select rule (this is the prefer bad dodgability rule):
	choose row stored_row in Table of AI Combat Weapon Options;
	decrease the Weight entry by the dodgability of the Weapon Option entry.

A standard AI weapon select rule (this is the prefer bad passive parry rule):
	choose row stored_row in Table of AI Combat Weapon Options;
	decrease the Weight entry by the passive parry max of the Weapon Option entry.

A standard AI weapon select rule (this is the prefer good active parry rule):
	choose row stored_row in Table of AI Combat Weapon Options;
	increase the Weight entry by the active parry max of the Weapon Option entry.

[Rule below: it is better to have a weapon with 2 passive parry max and 2 dodgability, than one with 4 passive parry max and 0 dodgability; because your enemy can use the weapon's weakness against you. This is reflected in the rule below.]

A standard AI weapon select rule (this is the prefer balanced parry and dodge rule):
	choose row stored_row in Table of AI Combat Weapon Options;
	let n be the dodgability of the Weapon Option entry;
	decrease n by the passive parry max of the Weapon Option entry;
	if n is less than 0, now n is 0 minus n;
	now n is n divided by 2;
	decrease the Weight entry by n.

A standard AI weapon select rule (this is the prefer good attack bonus rule):
	choose row stored_row in Table of AI Combat Weapon Options;
	let n be the weapon attack bonus of the Weapon Option entry;
	increase the Weight entry by n.

A standard AI weapon select rule (this is the prefer readied weapon if attacker almost dead rule):
	choose row stored_row in Table of AI Combat Weapon Options;
	if four times the health of the global attacker is less than the permanent health of the global attacker begin;
		if the Weapon Option entry is readied, increase the Weight entry by 3;
	end if.

A standard AI weapon select rule (this is the prefer readied weapon if defender almost dead rule):
	choose row stored_row in Table of AI Combat Weapon Options;
	if four times the health of the global defender is less than the permanent health of the global attacker begin;
		if the Weapon Option entry is readied, increase the Weight entry by 4;
	end if.

A standard AI weapon select rule (this is the slightly prefer readied weapon rule):
	choose row stored_row in Table of AI Combat Weapon Options;
	if the Weapon Option entry is readied, increase the Weight entry by 1.

[There is no random function here, because we don't want the AI to uselessly swap weapons.]


Chapter - Third Stage - Choosing an Action

The standard AI action select rules are a rulebook.

To have the AI select an action:
	blank out the AI Combat Options;
	consider the standard AI action select rules;
	sort the Table of AI Combat Options in random order;
	sort the Table of AI Combat Options in reverse Weight order;
	choose row one in the Table of AI Combat Options;
	now the stored_action is the Option entry. 

Section - Standard select rules

[For every possible action, there MUST be a "first" rule adding it to the table.]

First standard AI action select rule (this is the consider attacking rule):
	choose a blank Row in the Table of AI Combat Options;
	change the Option entry to the action of the global attacker attacking the global defender;
	change the Weight entry to 5.

First standard AI action select rule (this is the consider concentrating rule):
	choose a blank Row in the Table of AI Combat Options;
	change the Option entry to the action of the global attacker concentrating;
	change the Weight entry to 3.

First standard AI action select rule (this is the consider dodging rule):
	choose a blank Row in the Table of AI Combat Options;
	change the Option entry to the action of the global attacker dodging;
	if the combat state of the global attacker is not React begin;
		change the Weight entry to 1;
	otherwise;
		change the Weight entry to 5;
	end if.

First standard AI action select rule (this is the consider parrying rule):
	choose a blank Row in the Table of AI Combat Options;
	change the Option entry to the action of the global attacker parrying;
	if the combat state of the global attacker is not React begin;
		change the Weight entry to 1;
	otherwise;
		change the Weight entry to 5;
	end if.

First standard AI action select rule (this is the consider readying rule):
	choose a blank Row in the Table of AI Combat Options;
	change the Option entry to the action of the global attacker readying the stored_weapon;
	change the Weight entry to 0.

First standard AI action select rule (this is the consider reloading rule):
	choose a blank Row in the Table of AI Combat Options;
	change the Option entry to the action of the global attacker reloading the stored_weapon;
	change the Weight entry to 0.

Section - Calculating the chance to win

The chance to win rules is a rulebook.

The chance-to-win is a number that varies.

First standard AI action select rule (this is the calculate the chance to win rule):
	consider the chance to win rules.

First chance to win rule (this is the CTW default rule):
	now the chance-to-win is 10.

Chance to win rule (this is the CTW melee bonus rule):
	increase the chance-to-win by the melee of the global attacker.

Chance to win rule (this is the CTW defence bonus rule):
	decrease the chance-to-win by the defence of the global attacker.

[Other rules are in the appropriate sections.]

Last chance to win rule (this is the CTW no greater than 10 rule):
	if the chance-to-win is greater than 10, now the chance-to-win is 10.


Section - Standard rules

A standard AI action select rule (this is the standard attack select rule):
	choose row with an Option of the action of the global attacker attacking the global defender in the Table of AI Combat Options;
	if the chance-to-win is 0, change the Weight entry to -100;
	decrease the Weight entry by 5;
	increase the Weight entry by the chance-to-win.

A standard AI action select rule (this is the standard concentration select rule):
	choose row with an Option of the action of the global attacker concentrating in the Table of AI Combat Options;
	increase the Weight entry by 5;
	decrease the Weight entry by the chance-to-win;
	if the concentration of the global attacker is 3, now the weight entry is -100.

A standard AI action select rule (this is the concentration influences attacking rule):
	choose row with an Option of the action of the global attacker attacking the global defender in the Table of AI Combat Options;
	increase the Weight entry by the concentration of the global defender;
	if the concentration of the global defender is 3, increase the Weight entry by 2;
	[increase the weight entry by the concentration of the global attacker].

A standard AI action select rule (this is the standard parry and dodge select rule):
	repeat with X running through alive persons enclosed by the location begin;
		let d be 0;
		let p be 0;
		if X presses the global attacker begin;
			let item be a random readied weapon enclosed by X;
			increase d by the dodgability of item;
			let m be the passive parry max of item;
			if m is greater than active parry max of stored_weapon, now m is active parry max of stored_weapon;
			increase p by m;
		end if; [now we have calculated how good parrying and dodging are]
		choose row with an Option of the action of the global attacker dodging in the Table of AI Combat Options;
		increase the weight entry by d;
		if the global attacker is at parry, decrease the weight entry by 2;
		if d is not greater than p, now the weight entry is -100;
		if the global attacker is at dodge and the combat state of the global attacker is not React, now the weight entry is -100;
		choose row with an Option of the action of the global attacker parrying in the Table of AI Combat Options;
		increase the weight entry by p;
		if the global attacker is at dodge, decrease the weight entry by 2;
		[if the combat state of the global attacker is React, increase the weight entry by the concentration of the global attacker; [TODO]] [Only if I decide that parrying gets a Con bonus.]
		if d is greater than p, now the weight entry is -100;
		if stored_weapon is not readied, now the weight entry is -100;
		if the global attacker is at parry and the combat state of the global attacker is not React, now the weight entry is -100;
	end repeat.


A standard AI action select rule (this is the standard ready select rule):
	if the stored_weapon is readied begin;
		choose row with an Option of the action of the global attacker readying the stored_weapon in the Table of AI Combat Options;
		now the Weight entry is -100;
	otherwise;
		choose row with an Option of the action of the global attacker attacking the global defender in the Table of AI Combat Options;
		now the Weight entry is -100;
		choose row with an Option of the action of the global attacker concentrating in the Table of AI Combat Options;
		now the Weight entry is -100;
		choose row with an Option of the action of the global attacker readying the stored_weapon in the Table of AI Combat Options;
		increase the Weight entry by 5;		
	end if.

A standard AI action select rule (this is the standard reloading select rule):
	if the current shots of the stored_weapon is 0 and the maximum shots of the stored_weapon is not 0 begin;
		choose row with an Option of the action of the global attacker attacking the global defender in the Table of AI Combat Options;
		now the Weight entry is -100;
		choose row with an Option of the action of the global attacker concentrating in the Table of AI Combat Options;
		now the Weight entry is -100;
		choose row with an Option of the action of the global attacker reloading the stored_weapon in the Table of AI Combat Options;
		increase the Weight entry by 5;
	otherwise;
		choose row with an Option of the action of the global attacker reloading the stored_weapon in the Table of AI Combat Options;
		now the Weight entry is -100;
	end if.


Last standard AI action select rule (this is the randomise the action result rule):
	repeat through the Table of AI Combat Options begin;
		increase the Weight entry by a random number between 0 and 2;
		[say "[Option entry]: [Weight entry][line break]"; [For testing]]
	end repeat.



Chapter - Standard attacker AI

The standard_attacker is a rulebook.

A standard_attacker rule:
	have the AI select a target;
	if the found-a-target boolean is true begin;
		have the AI select a weapon;
		have the AI select an action;
		try the stored_action;
	end if.




Chapter - General AI definitions

A person has a rulebook called the combat AI rulebook. The combat AI rulebook of a person is usually the standard_attacker rulebook.









Book - Weapons

Chapter - The weapon kind



[A readied weapon is one that is not just carried by the actor, but actually in use.]

A weapon has a number called the damage die. The damage die of a weapon is usually 6.

[The damage die is the die size used to calculate damage.]

A weapon has a number called the dodgability. The dodgability of a weapon is usually 2.

[The dodgability of a weapon is the bonus a defender gets against it when dodging.]

A weapon has a number called the passive parry max. The passive parry max is usually 2.

[The passive parry max is the maximum bonus a defender can get when parrying AGAINST this weapon.]

A weapon has a number called the active parry max. The active parry max is usually 2.

[The active parry max is the maximum bonus a defender can get when parrying WITH this weapon.]

A weapon has a number called the weapon attack bonus. The weapon attack bonus of a weapon is usually 0.

Section - Weapon attack bonus

An attack modifiers rule (this is the attack bonus from weapon rule):
	let item be a random readied weapon enclosed by the global attacker;
	let n be the weapon attack bonus of item;
	if the numbers boolean is true begin;
		if n is greater than 0, say " + ", n, " ([item] bonus)[run paragraph on]";
		if n is less than 0, say " - ", n, " ([item] penalty)[run paragraph on]";
	end if;
	increase the to-hit modifier by n.

Chance to win rule (this is the CTW attack bonus from weapon rule):
	increase the chance-to-win by the weapon attack bonus of the stored_weapon.


Chapter - The ready action

Section - The action itself

Readying is an action applying to one touchable thing.

Understand "ready [weapon]" as readying.

Carry out an actor readying:
	if the actor encloses the noun begin;
		now the noun is readied;
		now the global actor is the actor;
		say "[CAP-actor] read[ies] [the noun].";
	otherwise;
		try the actor taking the noun;
		if the actor has the noun, now the noun is readied;
	end if;
	if the noun is readied begin;
		now the actor is not at parry;
		repeat with item running through things enclosed by the actor begin;
			if the item is not the noun and the item is readied, now the item is not readied;
		end repeat;
	end if.



After printing the name of a readied weapon while taking inventory:
	say " (readied)".

After dropping a readied weapon:
	now the noun is not readied; continue the action.

After putting on a readied weapon:
	now the noun is not readied; continue the action.

After inserting into a readied weapon:
	now the noun is not readied; continue the action.


Section - Natural weapons

A natural weapon is a kind of weapon.

A natural weapon is part of every person.

Instead of examining a natural weapon:
	say "Clenched fists, kicking feet--that kind of stuff.".

The damage die of a natural weapon is usually 3. The dodgability of a natural weapon is usually 2. The passive parry max of a natural weapon is usually 2. The active parry max of a natural weapon is usually 0.


Section - Natural weapons as a fallback option

First every turn rule (this is the ready natural weapons if no other weapon readied rule):
	repeat with X running through all alive persons enclosed by the location:
		if X encloses no readied weapon:
			let item be a random natural weapon part of X;
			now item is readied.

The ready natural weapons if no other weapon readied rule is listed in the when play begins rulebook.



Book - Reporting the Combat

Chapter - Reporting the blow

The intervening flavour text are a rulebook. [Use this to intervene in the normal procedure.]
The flavour are a rulebook. [In non-fatal cases]
The fatal player flavour are a rulebook. [When the player is killed.]
The fatal flavour are a rulebook. [When someone else is killed.]

The attack move flavour are a rulebook. [When someone attacks, before the other person reacts.]

A print flavour text rule:
	abide by the intervening flavour text rules;
	if the global defender is alive begin;
		abide by the flavour rulebook;
	otherwise;
		if the global defender is the player, abide by the fatal player flavour rulebook;
		if the global defender is not the player, abide by the fatal flavour rulebook;
	end if.
	
Chapter - Basic rules

Last flavour rule (this is the basic flavour rule):
	if the final damage is greater than 0 begin;
		say "[CAP-attacker] hit[-s] [the global defender].[run paragraph on]";
	otherwise;
		say "[CAP-attacker] miss[-es] [the global defender].[run paragraph on]";
	end if;
	continue the action.

Last fatal player flavour rule (this is the basic player flavour rule):
	say "[You] [are] killed by [the global attacker].".

Last fatal flavour rule (this is the basic fatal flavour rule):
	say "[CAP-attacker] kill[-s] [the global defender]." in sentence case.

Last attack move flavour rule (this is the basic attack move flavour rule):
	now the global actor is the actor;
	if the actor is not the player, say "[CAP-actor] lung[e-s] towards [the noun].[paragraph break]".




Volume - Subsystems


Book - Weapon Extras

Chapter - Reloading

A weapon has a number called the maximum shots. The maximum shots of a weapon is usually 0. A weapon has a number called the current shots. The current shots of a weapon is usually 0. A weapon has a number called the maximum load time. The maximum load time of a weapon is usually 0.  A weapon has a number called the current load time. The current load time of a weapon is usually 0.

Definition: a weapon is unloaded if its current shots is 0 and its maximum shots is not 0.

[Maximum shots: number of rounds the weapon can be used when fully loaded. Current shots: number of shots still loaded. Maximum load time: number of rounds it takes to load the weapon. Current load time: number of rounds it still takes to load the weapon.]

[Set maximum shots to 0 for any weapon that shouldn't use these statistics. Set maximum load time to -1 in case a weapon cannot be reloaded. NEVER set maximum load time to 0 for a weapon with maximum shots not 0.]

[The basic system does NOT deal with ammo. Everyone is assumed to have infinite ammunition.]

After printing the name of a weapon (called item) when taking inventory:
	if the maximum shots of item is not 0 begin;
		if the current shots of item is not 0 begin;
			say " ([current shots of item] of [maximum shots of item] shots left)";
		else;
			say " (no ammo; [current load time of item] rounds to reload)";
		end if;
	end if.

An aftereffects rule (this is the decrease ammo rule):
	if the maximum shots of the global attacker weapon is greater than 0 begin;
		decrease the current shots of the global attacker weapon by 1;
	end if.

Check attacking:
	let item be a random readied weapon enclosed by the player;
	if the maximum shots of item is greater than 0 begin;
		if the current shots of item is not greater than 0, say "You pull the trigger, but nothing happens--you're out of ammo!" instead;
	end if.

Reloading is an action applying to one carried thing.

Understand "reload [weapon]" as reloading.

Does the player mean reloading an unloaded readied weapon enclosed by the player: it is very likely.
Does the player mean reloading an unloaded weapon enclosed by the player: it is likely.

Check reloading:
	if the maximum shots of the noun is 0, say "[The noun] does not use ammo." instead;
	if the maximum load time of the noun is -1, say "[The noun] cannot be reloaded." instead;
	if the current shots of the noun is the maximum shots of the noun, say "[The noun] is already loaded." instead.

Carry out an actor reloading:
	now the noun is readied;
	decrease the current load time of the noun by 1;
	now the global actor is the actor;
	if the current load time of the noun is 0 begin;
		say "[CAP-actor] [if the maximum load time of the noun is 1]reload[-s][otherwise]finish[es] reloading[end if] [the noun].";
		now the current shots of the noun is the maximum shots of the noun;
		now the current load time of the noun is the maximum load time of the noun;
	otherwise;
		say "[CAP-actor] [if the current shots of the noun is not 0]discard[-s] the old ammo, and [end if][if the current load time of the noun plus 1 is the maximum load time of the noun]start[-s][otherwise]continu[e-s][end if] reloading [the noun].";
		now the current shots of the noun is 0;
	end if.


Section - Reloading and choosing a weapon

[Weapons with high load times and limited ammo should not be given a penalty if they are already readied and full; some penalty if they are not readied; and a larger penalty if they are not readied and out of ammo.]

Last standard AI weapon select rule (this is the do not prefer low ammo and long reload rule):
	choose row stored_row in Table of AI Combat Weapon Options;
	if the Weapon Option entry is readied and the current shots of the Weapon Option entry is greater than 0 begin;
		increase the Weight entry by 0;
	otherwise;
		let n be the Weight entry;
		let m be the maximum shots of the Weapon Option entry;
		let m be m + 1;
		let n be n times m;
		let m be m + the maximum load time of the Weapon Option entry;
		if the maximum load time of the Weapon Option entry is -1, increase m by 1;
		let n be n divided by m; [Weight * shots / (shots + reload) = Weight * percentage of useful turns. We add 1 to the shots in order to compensate for turns spent concentrating, defending, or so on.]
		now the Weight entry is n;
		if the current shots of the Weapon Option entry is less than 1, decrease the Weight entry by 1;
		if the current shots of the Weapon Option entry is less than 2, decrease the Weight entry by 1;
	end if.

[Weapons with 0 ammo and a maximum load time of -1 should NOT be chosen.]

Last standard AI weapon select rule (this is the do not chose an empty weapon that cannot be reloaded rule):
	choose row stored_row in Table of AI Combat Weapon Options;
	if the maximum shots of the Weapon Option entry is 0 begin;
		if the maximum load time of the Weapon Option entry is -1, now the Weight entry is -100;
	end if.




Volume - Extras

Section - Sword

A sword is a kind of weapon. The damage die of a sword is usually 7. The weapon attack bonus of a sword is usually 1. The passive parry max of a sword is usually 3. The active parry max of a sword is usually 4.


Flavour rule (this is the sword flavour rule):
	if the global attacker weapon is a sword begin;
		if the final damage is greater than 0 begin;
			let N be a random number between 1 and 5;
			if N is 1, say "[CAP-attacker] stick[-s] [possessive of the global attacker] sword into [the global defender dobj].[run paragraph on]";
			if N is 2, say "[CAP-attacker] feint[-s], then suddenly reverses the sword's direction and scor[e-s] a hit against [the global defender dobj].[run paragraph on]";
			if N is 3, say "With several deft movements, [the global attacker sub] manag[e-s] to bypass [possessive of the global defender] defences. Fresh blood stains the tip of the sword.[run paragraph on]";
			if N is 4, say "A thrust, a parry--and [the global attacker sub] se[e-s] an opening. With a fierce stroke [the global attacker sub] wound[-s] [the global defender dobj].[run paragraph on]";
			if N is 5, say "[CAP-attacker] appear[-s] to aim high, but duck[-s] suddenly and scor[e-s] a solid blow.[run paragraph on]";
		otherwise;
			say "[CAP-attacker] miss[-es] [the global defender dobj] by inches.[run paragraph on]";
		end if;
		stop the action;
	end if.



















[==================================================]







Book - The Game

Chapter - The player character

Instead of examining the player:
	say "As good-looking as ten years ago, or twenty--or a hundred, for that matter."

Rule for printing the name of a natural weapon:
	if the natural weapon is enclosed by the player, say "my hands and feet".

[Rule for printing the name of yourself:
	say "me".]

To say possessive of (item - a thing):
  change the prior named noun to the item;
  mark prior named noun in output;
  if the item is the player
  begin;
  	say "my";
  otherwise if the item acts plural;
  	say "[the item][apostrophe]";
  otherwise;
  	say "[the item][apostrophe]s";
  end if.

To say Cap possessive of (item - a thing):
  change the prior named noun to the item;
  mark prior named noun in output;
  if the item is the player
  begin;
  	say "My";
  otherwise if the item acts plural;
  	say "[The item][apostrophe]";
  otherwise;
  	say "[The item][apostrophe]s";
  end if.

My teeth are a part of the player.

Instead of examining my teeth: say "As pointy as a wizard's hat.".
Instead of dropping my teeth: say "They are a part of me.".
Instead of inserting my teeth into: say "They are a part of me.".


Chapter - Score

The maximum score is 100.

Table of custom library messages (continued)
Message Id				Message Text
LibMsg <score changed>	"My score has just gone [if numeric amount >= 0]up by [the numeric amount][otherwise]down by [0 minus the numeric amount][end if] point[s]"
 LibMsg <Score command>	"[if game over]In that game I[otherwise]I have so far[end if] scored [the score] out of a possible [maximum score] point[s]"
 LibMsg <score rank>	". I [one of]guess[or]suppose[or]assume[at random] that makes me " 



Table of Tasks Achieved
Points	Citation						Time
1		"retrieving my old sword"	a time
1		"finding the medicine"
3		"administering the medicine"
1		"killing the raven"


To record (T - text) as achieved:
	choose row with a Citation of T in the Table of Tasks Achieved;
	if there is no Time entry:
		change Time entry to the time of day;
		award Points entry points;
		[say "[line break](My score has just gone up by [Points entry] point[s].)"]. [I don't understand why the library message is not printed by the previous statement?? This is merely an ugly workaround.]

Requesting the full score is an action out of world. Understand "full" or "full score" as requesting the full score.

Carry out requesting the full score:
	if the score is 0, say "I should be finding that medicine, not asking about my score!" instead;
	say "So far I've awarded myself points for the following: [line break]";
	repeat through the Table of Tasks Achieved in time order:
		say "[line break]  [citation entry] ([points entry] point[s])";
	say "[line break]".

Table of Rankings
Score	Rank
0		"a hopeless hermit"
5		"[one of]a Samaritan[or]a cowboy[or]Julius Caesar[as decreasingly likely outcomes]"
10		"[one of]a wanderer[or]a killer[or]the Walrus[as decreasingly likely outcomes]"


Chapter - Status Bar


Table of Fancy Status
left	central	right
"[bold type]Task at hand[roman type]: [task at hand]"	""	"[bold type][location of the player][roman type]"
"I am [current feeling], [harm status], and armed with [a random readied weapon enclosed by the player]."	""	"Score: [score]/100"

Rule for constructing the status line:
	fill status bar with Table of Fancy Status;
	rule succeeds. 

Section - Task

Task is a kind of value.

The tasks are finding the medicine, administering the medicine, waiting for the boy to recover, killing the raven, who knows?.

The task at hand is a task that varies. The task at hand is finding the medicine.

Section - Feelings

Feeling is a kind of value.

The feelings are restless, pensive, blood rush, extreme agony, excited, sad, tired.

The current feeling is a feeling that varies. The current feeling is restless.

Section - Harm

To say harm status:
	let n be 10 times the health of the player;
	now n is n divided by the permanent health of the player;
	if n is:
		-- 10: say "unharmed";
		-- 9: say "scratched";
		-- 8: say "lightly wounded";
		-- 7: say "wounded";
		-- 6: say "wounded";
		-- 5: say "severely wounded";
		-- 4: say "severely wounded";
		-- 3: say "[bold type]bleeding copiously[roman type]";
		-- 2: say "[bold type]losing limbs[roman type]";
		-- otherwise: say "[bold type]dying[roman type]".

To say when wounded:
	if the global defender is the player:
		if the final damage is greater than 0:
			say " (I am now [bold type][harm status][roman type].)[run paragraph on]".


Section - Changing the defaults in Conversation framework

The implicit-conversing needs current interlocutor rule is not listed in any rulebook.

Before implicit-conversing when the current interlocutor is not a person (this is the first-person implicit-conversing needs current interlocutor rule):
	let np be the number of visible people who are not the player;
	if np is 0 then say "There's no one here to talk to.";
	if np > 1 then say "I wonder who I should talk to.";
	if np is not 1 then stop the action;
	let the interlocutor be a random visible person who is not the player;
	 if the interlocutor is a person begin;
		say "(addressing [the interlocutor])";
		let sn be the second noun;
		implicitly greet the interlocutor;
		change the second noun to sn;
	otherwise ;
		say "I'm not talking to anyone.";
	stop the action;
	end if.

The can't greet current interlocutor rule is not listed in any rulebook.

Check saying hello to a person when the noun is the current interlocutor (this is the first-person can't greet current interlocutor rule):
    say "I am already talking to [the noun]." instead.

The default greeting rule is not listed in any rulebook.

Report saying hello to someone when the greeting type is explicit (this is the first-person default greeting rule):
  say "'Hi, [ noun].'"

The check what's being hailed rule is not listed in any rulebook.

Check hailing (this is the first-person check what's being hailed rule):
	if the current interlocutor is a visible person then
		say "I am already talking to [the current interlocutor]." instead;
	change the noun to a random visible person who is not the player;
	if the noun is a person then 
		say "(addressing [the noun])";
	otherwise say "I'm all alone." instead.

The can't say goodbye to someone you're not talking to rule is not listed in any rulebook.

Check saying goodbye to something when the noun is not the current interlocutor (this is the first-person can't say goodbye to someone you're not talking to rule):
	say "I'm not talking to [the noun]." instead.

The don't allow saying goodbye to no-one rule is not listed in any rulebook.

Check leavetaking when the current interlocutor is not a visible person (this is the first-person don't allow saying goodbye to no-one rule):
	say "I'm not talking to anyone." instead.

The default saying goodbye rule is not listed in any rulebook.

Report saying goodbye to someone when the farewell type is explicit (this is the first-person default saying goodbye rule):
	say "'See you, [noun].'"

Section - Changing the defaults in Conversation Suggestions

["First" hopefully goes before the other, UNNAMED rule.]

First check listing suggested topics when the current interlocutor is not a person:
  say "I'm not talking to anyone right now." instead.

[Here defining a phrase in a later place overwrites the former definition.]

To say nothing specific:
   say "I [one of]have nothing specific in mind to discuss with [the current interlocutor][or]can't really think of anything interesting to say to [the current interlocutor][or]am somewhat at a loss for conversation topics[or]wouldn't really know what to say to [the current interlocutor][at random].";

[For the other rules, I'm just EDITING CONVERSATION SUGGESTIONS. This is a BAD thing. Extension authors should take better care!]



Section - Default conversation responses

Default ask response:
	say "[one of]I don't have any well-formed questions about that[or]That would hardly be worth the trouble[or]I wouldn't know what to ask about that[or]In our world, curiosity not only kills the cat but eats its brains afterwards[as decreasingly likely outcomes].".

Default tell response:
	say "[one of]There's nothing particular I want to say about that[or]Nothing comes to mind to say[or]I don't really want to talk about that[or]There are two secrets to becoming great. One is never to reveal all that you know[as decreasingly likely outcomes].".

Section - I don't want requesting it for and imploring it for

Instead of requesting someone for:
	say "I don't like asking people [italic type]for[roman type] things. [italic type]About[roman type] things, well, that's something else.".

Instead of imploring someone for:
	say "I don't like asking people [italic type]for[roman type] things. [italic type]About[roman type] things, well, that's something else.".

Section - I want TOPICS after each conversation step

The not-suggest boolean is a truth state that varies.

Every turn when the not-suggest boolean is false:
	if the current action is quizzing someone about:
		change topic-request to implicit;
		try listing suggested topics;
		change topic-request to explicit.

Every turn when the not-suggest boolean is false:
	if the current action is informing someone about:
		change topic-request to implicit;
		try listing suggested topics;
		change topic-request to explicit.

Every turn:
	now the not-suggest boolean is false.

[If for some reason you don't want to see suggestions, just make sure the quizzing/informing rulebook used sets the not-suggest boolean to true. See the boy when he has not yet gotten the medicine.]


Section - Changing the defaults of ATTACK

When play begins:
	now the numbers boolean is false.

The do not attack yourself rule is not listed in any rulebook.

A check attacking rule (this is the new do not attack yourself rule):
	if the noun is the player, say "I'm not feeling particularly suicidal today." instead.

The only attack persons rule is not listed in any rulebook.

A check attacking rule (this is the new only attack persons rule):
	if the noun is not a person, say "Beating the crap out of insensible things may be fun, but sometimes, just sometimes, you shouldn't indulge in what is fun." instead.

The only attack the living rule is not listed in any rulebook.

A check attacking rule (this is the new only attack the living rule):
	if the noun is not alive, say "[The noun] is already as dead as I will be able to make it." instead.

The do not attack friendly people rule is not listed in any rulebook.
The do not attack neutral people rule is not listed in any rulebook.

A check attacking rule (this is the new do not attack friendly-neutral people rule):
	if the hostility of the noun is friendly or the hostility of the noun is neutral, say "[The noun] is my friend. I don't hurt my friends. (Or at least not much. If I can help it. Which I can. In this case, I mean. Damn these tortuous strands of thought that forever keep twisting my mind!)" instead.





Section - Responses for standard actions

Instead of singing:
	say "I [one of]sing[or]sing[or]hum[or]whistle[or]croak[or]croon[or]grunt[or]warble[at random] [one of]the first few lines of[or]a couple of lines from[or]some lines from[or]a sizable part of[or]a particularly garbled version of[at random] [italic type][a song][roman type][if a random chance of 1 in 20 succeeds] (putting on a thick and militaristic German accent, à la Laibach)[otherwise if a random chance of 1 in 15 succeeds] (although I hardly remember the lyrics)[end if].".

To say a song:
	say "[one of]I am the Walrus[or]Sloop John B[or]Sympathy for the Devil[or]Losing my Religion[or]Paranoid Android[or]Master of Puppets[or]Heidenröslein[or]Madamina, il catalogo è questo[or]Mache dich, mein Herze, rein[or]Killer Queen[or]No Limit[or]Money Money Money[or]Barbie Girl[or]Cruelty Brought thee Orchids[or]I Will Survive[or]Vampire Punk Rockers from Hell[or]If I was your Vampire[or]Sweet Transvestite[or]A Succubus in Rapture[or]Thus Spake the Nightspirit[or]The Final Countdown[in random order]".

Instead of thinking:
	say "[one of]Wait, I've hit on a solution for the 3[italic type]n[roman type]+1 problem![or]I contemplate the deep problems of existence.[or]That made me lose the game.[or]I take twenty seconds to abandon myself to existential doubt.[or]I try, but it's not easy.[or]All I can think of is [task at hand].[or]I think about love, kindness, beauty and pencils.[or]I dream about blood.[in random order]".

Instead of jumping:
	say "My slender body moves through the air with what I can only call feline grace as I proufly defy the very laws of gravity. They accept the challenge; and predictably win.".

Instead of swearing obscenely:
	if at least one hostile alive person is enclosed by the location begin;
		let X be a random hostile alive person enclosed by the location;
		say "'Come here, [one of]you slimy fucking walrus-looking piece of shit[or][X], and I will gouge out your eyeballs and skull-fuck you[at random]!'";
	otherwise;
		say "'Damn.'";
	end if.

Instead of sleeping:
	say "I spent most of the past three decades sleeping. I'm bored of sleeping.".

Instead of waving hands:
	say "[one of]I wave my life goodbye.[or]I make some mysterious kung-fu moves (which I'd better not bring into practice).[or]I wave to whomever may be looking.[at random]".



Chapter - New Actions

Dying is an action out of world. Understand "die" as dying.

Carry out dying:
	say "I tried that once, but then quickly typed '> UNDIE'.".

Undying is an action out of world. Understand "undie" as undying.

Carry out undying:
	say "They don't make them any more undead than me, you know.".

Finding is an action applying to a topic. Understand "find [text]" as finding.

Instead of finding:
	say "I'm not a search engine, now am I?".

Sighing is an action out of world. Understand "sigh" as sighing.

Carry out sighing:
	say "I emit a deep and profound sigh.".



Volume - First Chapter

Part - Scenes

First chapter is a scene. First chapter begins when play begins.


Part - The Cabin

The Cabin is a room. "Not much here, but I don't need much. There's a large table beneath the window, covered with various sundries and oddments. There's a trunk opposite the door, and then there's the bed[if the player is in the cabin for the first turn]. On which, I ought not fail to mention, lies the boy--still asleep, and not looking any better.[paragraph break]I really should find that medicine[end if]."

The player is in the cabin.

Chapter - Furniture and items

Section - The table

The table is in the cabin. The table is scenery. The table is a supporter.

Instead of examining the table:
	say "Well, it's a table. It sure won't win any competitions for style, but it was here when I occupied the place, and I've never bothered to get a replacement. You can stack things on it, and that's good enough for me. I tend to spend most of my time in torpor anyway.".

Instead of looking under the table:
	if the black sword is handled, say "Nope, no more treasures hidden there.";
	if the black sword is not handled begin;
		say "Why yes, my old sword lies there gathering dust and, I don't know, whatever else old swords do with their copious free time. I pick it up--for I have a hunch that it will come in handy tonight.";
		now the black sword is handled;
		repeat with item running through weapons enclosed by the player begin;
			now item is not readied;
		end repeat;
		now the black sword is readied;
		move the black sword to the player;
		record "retrieving my old sword" as achieved;
	end if.

Torpor is a thing. It is scenery. It is in the cabin. It is an enterable container.

Instead of entering torpor:
	say "Never when I have guests.".

Instead of doing anything except entering to torpor:
	say "It's not some physical object I can manipulate.".


Section - The black sword

The black sword is a sword.

Instead of examining the black sword:
	say "It has the colour of my soul, and the sharpness of my mind... oh, crap. It's just something I bought once and held on to because it's good at what it has to do: dissect and decapitate those who wish to stick their weapons in my own proper entrails.".

On the table is a thing called various sundries and oddments.  It is scenery. It is plural-named. The indefinite article is "some".

Section - The various sundries and oddments

Instead of examining the various sundries and oddments:
	say "Just the usual bric-a-brac: dirty plates, manila folders full of useless papers, pieces of string, a Beethoven compact disc, bottles (all empty), [if the stuffed toy is not handled]a stuffed toy, [end if]two Beatles cassettes (both of them [italic type]Magical Mystery Tour[roman type], so that's a lot of strawberry fields), [if the teapot is not handled]an old teapot, [end if]two novels and a rotting cucumber.".

Understand "usual" and "bric-a-brac" as the various sundries.

Section - The dirty plates

The dirty plates are a thing. It is scenery. It is plural-named. It is part of the sundries. The indefinite article is "some".

Instead of examining the dirty plates:
	say "Congealed blood from my sparse meals stains the plates. Not a pretty sight--but it must be some comfort to know I don't lick them clean.".

Instead of taking the dirty plates:
	say "I don't think this is such a great time to do the washing up.".

Understand "congealed" and "blood" as the dirty plates.

Section - Manila folders

The manila folders full of useless papers are a thing. It is scenery. It is plural-named. It is part of the sundries. The indefinite article is "some".

Understand "manilla" and "letter" and "letters" and "paper" and "postcards" and "bills" as the manila folders.

Instead of examining or opening the manila folders:
	say "Why do I even keep this crap? There are bills that I paid years ago, postcards that I never sent, letters from people dead for decades or longer. None of it any use to anyone.".

Instead of taking the manila folders:
	say "No. Better to leave them undisturbed.".

Section - Pieces of string

The pieces of string are a thing. It is scenery. It is plural-named. It is part of the sundries. The indefinite article is "some".

Instead of examining the pieces of string:
	say "They used to be connected into a single cord, with which I once tried to hang myself. Turned out it wasn't strong enough, which I don't regret. All that often.".

Instead of taking the pieces of string:
	say "It's a rather unpleasant memory, and I rather not carry it around with me.".

Section - Beethoven compact disc

The Beethoven compact disc is a thing. It is scenery. It is part of the sundries.

Instead of examining the Beethoven compact disc:
	say "It's the third Cello Sonata, opus 69. Great music, which is why I kept it. Though, what with a lack of CD players and electricity, I now mostly use it as a mirror.".

Understand "cello" and "sonata" and "opus" and "69" as the Beethoven compact disc.

Instead of taking the Beethoven compact disc:
	say "I pick up the CD for a moment and cast a glance into the shiny side. Still as good-looking as ever. In fact, somewhat improved by that hole in the middle of my face with a finger poking out of it.".

Instead of listening to the Beethoven compact disc:
	say "I put the disc on my left hand index finger, and spin it with my right hand, as fast as I can. No luck; still no music coming out of it. (I have amused myself with this joke at least forty times in the last three months alone.)".

Section - Bottles

The bottles are a thing. It is scenery. It is plural-named. It is part of the sundries. The indefinite article is "some".

Instead of examining the bottles:
	say "Jack Daniels, Four Roses, Chivas Regal--cheap booze, really. I wouldn't have even [italic type]considered[roman type] drinking it fifty or even twenty years ago, in those glorious centuries before I cloistered myself here. But now--[paragraph break]  How weary, stale, flat, and unprofitable[line break]  Seem to me all the uses of this world![paragraph break]Of course they still seem stale and flat and whatnot [italic type]after[roman type] getting pissed, but due to my 'affliction' I never get a hangover, so after a bout of drunkenness I've at least got [italic type]that[roman type] to be thankful for. It makes me count my blessing.".

Instead of taking the bottles:
	say "They're empty. I need empty bottles like I need a tanning bed.".

Section - A stuffed toy

The stuffed toy is a thing. It is scenery. It is part of the sundries.

Instead of examining the stuffed toy:
	say "[if the boy carries the stuffed toy]The boy holds the bear tightly. It appears to comfort him[otherwise]It's a teddy bear. I'd rather not go into how I got it, but I think it used to be called 'Brown'. I sometimes stare into its eyes and try to persuade myself that some kind of intelligence resides in his little stuffed head. Yeah, it can get lonely here[end if].".

Understand "Brown" and "eyes" and "teddy" and "bear" as the stuffed toy.

Instead of taking the stuffed toy for the first time:
	say "Why not? I extricate the teddy bear from the pile in which it lay buried.";
	move the stuffed toy to the player;
	now the stuffed toy is not scenery;
	now the stuffed toy is not fixed in place.

Section - Beatles cassettes

The cassettes are a thing. It is scenery. It is plural-named. It is part of the sundries. The indefinite article is "two".

Understand "two" and "beatles" and "magical" and "mystery" and "cassette" and "tour" and "tape" and "tapes" as the cassettes.

Instead of examining the cassettes:
	say "Why do I even have a single tape with [italic type]Magical Mystery Tour[roman type] on it? An unanswerable question, which makes the fact that I have [italic type]two[roman type] one of the great enigmas of the Universe. I don't even particularly [italic type]like[roman type] the album; but at least it's not sergeant Pepper.".

Instead of taking the cassettes:
	say "I don't need those cassettes; only love.".

Instead of listening to the cassettes:
	say "I place my ear right next to the cassettes. They are silent.".

[And now for a little joke.]

Love is a thing. It is scenery. It is in the cabin.

Instead of taking love:
	say "That can be given, but never taken. Believe me--I've tried.".

Instead of examining love:
	say "[one of]A madness most discreet, a choking gall and a preserving sweet[or]The most beautiful of dreams and the worst of nightmares[or]A familiar; a devil. Though the rumour that there is no evil angel but Love is certainly false[at random].".

Instead of doing anything except taking or examining to love:
	say "It's not some physical object I can manipulate.".


Section - Teapot

The teapot is a thing. It is scenery. It is part of the sundries. It is a closed openable container.

Understand "pot" and "old" as the teapot.

Instead of examining the teapot:
	say "An ornate teapot with large floral designs all over--exactly my style. Since I don't drink tea, I mainly use the thing to store small objects in, which otherwise might, you know, get lost.".

Instead of taking the teapot for the first time:
	say "I pick up the old teapot[if the medicine is in the teapot]. Something rattles inside[end if].";
	move the teapot to the player;
	now the teapot is not scenery;
	now the teapot is not fixed in place.

Before listening to the teapot:
	if the medicine is in the teapot, say "Yeah, definitely a rattle." instead.

Before opening the teapot when the teapot is scenery:
	now the teapot is not scenery;
	now the teapot is not fixed in place;
	move the teapot to the table.


Section - The medicine

The medicine is a thing. It is in the teapot. The indefinite article is "some".

Understand "tablet" and "pill" and "paracetamol" as the medicine.

After taking the medicine for the first time:
	say "I gingerly take the tablet--only one left? what did I do with all the others?--from the teapot. It's my own recipe: mainly paracetamol, but some other good things mixed in as well. It has never failed me before, and I have been a doctor for years[if a random chance of 1 in 4 succeeds]. Twice, actually--though we didn't have paracetamol the first time around, and my patients didn't care much for leeches anymore the second, which kind of took away the point of the whole enterprise[end if].";
	record "finding the medicine" as achieved;
	now the task at hand is administering the medicine.

Instead of examining the medicine:
	say "It's my own recipe: mainly paracetamol, but some other good things mixed in as well, and pressed into a beautiful pill[if the boy carries the medicine]. Currently, it resides in boy's mouth[end if].".

Section - Novels

The novels are a thing. It is scenery. It is plural-named. It is part of the sundries. The indefinite article is "two".

Understand "novel" and "book" and "books" and "Dante" and "Paradiso" and "Purgatorio" and "divine" and "divina" and "comedy" and "comedia" as the novels.

Instead of examining the novels:
	say "Dante's [italic type]Purgatorio[roman type] and [italic type]Paradiso[roman type], in a side-by-side English-Italian version. (So maybe they're not exactly novels, but who cares.)".

Instead of taking the novels:
	say "Someday, when the sudden urge to reread that story of grace and redemption for the umpteenth time compels me, I'll pick them up.".

The Inferno is a thing. It is scenery. It is part of the sundries.

Instead of examining or taking or searching the Inferno:
	say "I don't have the [italic type]Inferno[roman type]. I don't need it.".

Section - Rotting cucumber

The rotting cucumber is a thing. It is scenery. It is part of the sundries.

Instead of examining the rotting cucumber:
	say "It was doomed to devolve into this mess the moment it came into my house, since I never eat vegetables. Right now it's looking so vile that anything but a prokaryote would have the sense to stay away."

Instead of taking or touching the rotting cucumber for the first time:
	say "I first sing a few lines that pop into my head unbidden:[paragraph break]  Sleep, baby, sleep, in peace may you slumber,[line break]  No danger lurks, so sleep, my cucumber.[paragraph break]Of course, that fills me with such tender thoughts that I decide to leave the cucumber decomposing where it so innocently lies.".

Instead of taking or touching the rotting cucumber:
	say "No, no--I'm not going to break my promise to this noble member of the plant kingdom.".

Instead of smelling the rotting cucumber:
	say "I've been in the cabin all day, so I don't really notice it anymore. It is presumably foul.".

Before of eating or tasting the rotting cucumber:
	say "[italic type]Some[roman type] fates worse than death have been spared me. Few enough, if you ask me." instead.


Section - Trunk

The trunk is in the cabin. The trunk is scenery. The trunk is a closed locked openable container.

Instead of examining the trunk:
	say "Being made out of metal, its main quality is heaviness. (Though it's also quite ugly.) My philosophy is that it's no good to lock your stuff up if anyone can just carry off the container.".

Instead of taking or pushing or pulling the trunk:
	say "It's heavy as hell. That means it's a bit too heavy for me to raise.".

Instead of opening the trunk:
	say "It is securely locked, both because I don't want anyone to get [italic type]in[roman type] and because I don't want anything to get [italic type]out[roman type]. It'll remain locked if I can help it.".

Section - Holy water

The holy water is a thing. It is in the trunk.

Instead of examining the holy water:
	say "It looks like a normal vacuum flask. Indeed, it [italic type]is[roman type] a normal vacuum flask; but it is filled with a solution of benzoic acid, also known as E210. Nothing special--except that for people like me, touching it is agony and ingesting it is death. One of the very few fail-safe methods for doing away with us; and a proof (as if we needed one) that chemists are the new priests.".


Section - Door

The door of the cabin is a closed door. It is south of the cabin. It is scenery.

Instead of opening the door:
	say "I don't think the cold night air would be good for the boy.".

Instead of examining the door:
	say "I prefer doors over windows. You can always try to convince yourself that there lies something special and new beyond a door, an entirely new world you might enter just by opening it. Windows, on the other hand, make the mundaneness of what lies beyond them only too apparent.".


Section - Window

The window of the cabin is a thing. It is scenery. It is in the cabin.

Instead of opening the window:
	say "I don't think the cold night air would be good for the boy.".

Instead of examining the window:
	say "I prefer doors over windows. You can always try to convince yourself that there lies something special and new beyond a door, an entirely new world you might enter just by opening it. Windows, on the other hand, make the mundaneness of what lies beyond them only too apparent. Though it's night now, so that alleviates the pain.".


Section - Bed

The bed is a thing. It is scenery, container and enterable. It is in the cabin.

Instead of examining the bed:
	say "Not exactly comfortable, but I'm not a light sleeper. More like a comatose sleeper[if the boy is in the bed]. Currently, the boy lies in it[end if].".

Instead of taking or pushing or pulling the bed:
	say "'You'd better pay up, sonny, or next time it won't be just your furniture we rearrange.'".

Instead of entering the bed:
	if the boy is in the bed begin;
		say "The first moment I believe that the boy needs my body warmth to survive, I'll do so.";
	otherwise;
		say "Art mad? This is not time for dallying.";
	end if.

Section - Can of beer

The can of beer is a thing.  The can of beer is a closed openable container.

Understand "Heineken" as the can of beer.

Instead of looking under the bed:
	if the can of beer is handled, say "Nope, that was all the beer I had.";
	if the can of beer is not handled begin;
		say "So that's where it went to! I [italic type]knew[roman type] I still had a can of Heineken.";
		now the can of beer is handled;
		move the can of beer to the player;
	end if.

Instead of examining the can of beer:
	say "Heineken. If there was an award for tastelessness--in the most literal sense--it ought to be awarded to this dubious brew. Still, it's a lot better than water.".

Instead of inserting anything into the can of beer:
	say "Perhaps not.".

Instead of drinking the beer:
	if the fever boolean is false begin;
		say "I quaff the heavenly beverage. Or the lukewarm beer. Since I won't be needing the can anymore, I throw it into some corner where I'll hopefully never find it again.";
		remove the can of beer from play;
	otherwise;
		if the can of beer is closed, say "Suppose I hadn't realised beforehand that the can is still closed. How funny it would have been to see me try to take a swallow! I could have made jokes about that for, oh, weeks. More than a month, perhaps. I'm a comedian, you see. I would pick up the can again and imitate myself by raising it, turning my face into a mask of glorious anticipation (like you see it on the TV), and then, the hilarious punchline, no beer comes out! Can you imagine the look of disappointment (which I would have weeks to perfect)? Yeah, it's a damn pity I [italic type]do[roman type] realise that I ought to open the can before drinking from it.";
		if the can of beer is open, say "No, I'm pretty sure I'm going to need it.";
	end if.

Report opening the can of beer:
	say "I pop open the can of beer; upon which the contents all too enthusiastically attempt to scatter themselves over my floor. I manage to save the situation with a couple of quick gulps--but hey, I didn't shake this thing, did I? Life sure isn't fair." instead.
	.

Chapter - Boy

The boy is a person. The boy is in the bed. The hostility of the boy is neutral

The fever boolean is a truth state that varies. The fever boolean is true. [True until the boy has been given the medicine and some more time has passed.]

The medicine given boolean is a truth state that varies. The medicine given boolean is false. [Becomes true when the medicine has been given.]

The bloodlettings is a number that varies. The bloodlettings is 0. [Will go up every time then player character drinks the boy's blood.]

Instead of examining the boy for the first time during first chapter:
	say "About an hour ago, he came knocking on my door; and so softly he came tapping that at first I scarce was sure I heard him. But I got up anyway, and when I opened the door he just collapsed inside. Couldn't speak a word before he lost consciousness[if the fever boolean is true]. Heaven may know what brought him here in this godforsaken waste; but I guess I'll never find out unless I save him[end if].".

Instead of examining the boy during first chapter:
	if the fever boolean is true begin;
		say "Drops of sweat form on his brow, and his sleep is not exactly unperturbed--sudden movements, whispered phrases, small shrieks. To be honest, I'm a bit worried about the whole thing.";
	otherwise;
		say "That medicine certainly worked, if I may pat myself on the back. I wouldn't say the boy looks [italic type]healthy[roman type], what with the white skin and the fatigued eyes, but he certainly looks [italic type]better[roman type] than he did when I first saw him. A condition that is all too rare.";
	end if.

Instead of touching the boy during first chapter:
	if the fever boolean is true begin;
		say "[one of]I wipe the sweat off his face with my sleeve, then[or]I[stopping] lay my hand upon his brow. All humans feel hot to me, but this is [italic type]too[roman type] hot.";
	otherwise;
		say "I lightly touch the boy's brow. His fever has subsided and I inwardly smile.";
	end if.

Instead of listening to the boy during first chapter:
	if the fever boolean is true begin;
		say "The boy seems to be muttering something in his sleep, [one of]but when I lean closer to him, all I catch are meaningless strings of syllables[or]something about 'cold' and 'dark' and 'fast'[or]and as I lean closer I distinctly hear him say 'please help me, Master'[or]but in my ears it is not as loud as the sound of his blood gushing through his arteries[as decreasingly likely outcomes].";
	otherwise;
		say "I hear his breath as it enters and leaves the cavities of his body; I hear his blood as it flows through... no, that must be my imagination. How did that song go? 'Sometimes I give myself the creeps... Sometimes my mind plays tricks on me...'.";
	end if.

Instead of kissing the boy during first chapter:
	say "[one of]That would be... wouldn't that be too... I mean, that's [italic type]intimate[roman type][or]No, not a good idea[stopping].".


Section - Giving the boy the toy

Instead of giving the stuffed toy to the boy:
	move the stuffed toy to the boy;
	if the fever boolean is true begin;
		say "I carefully tuck the teddy bear into the bed, next to the boy. He, still sleeping, puts his hands around the toy and pulls it tight against his own shivering body.";
	otherwise;
		say "'Here, maybe you can keep this safe for me,' I tell him. He nods seriously, and pulls the bear tight against his own shivering body.";
	end if.

Instead of taking the stuffed toy when the stuffed toy is carried by the boy:
	say "I'm not going to take the bear away from the boy.".

Instead of inserting the stuffed toy into the bed when the boy is in the bed:
	try giving the stuffed toy to the boy.	

Instead of putting the stuffed toy on the bed when the boy is in the bed:
	try giving the stuffed toy to the boy.


Section - Giving the boy the medicine

Instead of giving the medicine to the boy:
	say "I wake up the boy a little, and put the tablet into his mouth. He hardly seems conscious of what's going on; and when I implore him to swallow the medicine, he either doesn't understand me or is incapable of doing what I ask. I doubt I'm going to get that pill into him if I don't give him something to drink--just a little sip of whatever should help him swallow it down[if the can of beer is not handled]. Problem is: I never drink, at least not anything I could give the boy[end if].";
	move the medicine to the boy.

Instead of taking the medicine when the medicine is carried by the boy:
	say "No, I just need to give the boy something to drink.".

Every turn (this is the beer hint rule):
	if the medicine is carried by the boy for six turns begin;
		if the can of beer is not handled, say "Wait--I seem to remember there was a can of something near the bed, not too long ago. Maybe it's still there.";
	end if.

Check giving the can of beer to the boy:
	if the can of beer is closed, say "Perhaps I should open the can first. Just a suggestion.".

Instead of giving the can of beer to the boy:
	if the medicine is carried by the boy begin;
		remove the medicine from play;
		say "I pull the boy a little upright and pour some of the beer into his mouth. He swallows. That's great. I lay him down again, and pull the covers up to his neck. All I can do now is wait until the fever subsides and he wakes.";
		record "administering the medicine" as achieved;
		now the medicine given boolean is true;
		now the task at hand is waiting for the boy to recover;
	otherwise;
		say "I don't think the beer would be a very good medicine.";
	end if.

Section - Boy's default responses

Default show response for the boy when the fever boolean is true:
	say "The boy is in no condition to look.".

Default give response for the boy when the fever boolean is true:
	say "The boy is in no condition to accept things.".

Default show response for the boy:
	say "The boy looks with interest at [the noun].".

Default give response for the boy:
	say "The boy looks with interest at [the noun], but doesn't take [it-them].".

Section - Boy's first chapter conversation

Instead of quizzing or informing boy about when the fever boolean is true:
	say "I'm not going to talk to the boy before I've given him the medicine.";
	now the not-suggest boolean is true.

Every turn when the fever boolean has been false for exactly two turns:
	say "The boy coughs weakly.".

There is a familiar thing called the reason for his visit. There is a familiar thing called doctors. There is a familiar thing called New Haven. 
The ask-suggestions of the boy are {self-suggestion, reason for his visit}.
The tell-suggestions of the boy are {the medicine}.

Response of boy when asked about boy during first chapter:
	say "[one of]'How are you feeling, boy?'[paragraph break]'Much better, thank you, sir,' the boy replies shyly. 'I think you saved my life, sir.'[or]'Still feeling okay?'[paragraph break]'Yes, sir. Thank you, sir.'[stopping][remove self-suggestion ask suggestion]".

Response of the boy when told about medicine during first chapter:
	say "'The medicine that I've given you? It's my own recipe. You won't find anything as good within a hundred kilometers from here, I promise you.'[paragraph break]The boy looks suitably impressed. 'Are you... are you a doctor, sir?'[remove medicine tell suggestion][add doctors tell suggestion]".

Response of the boy when told about doctors during first chapter:
	say "'Ha, I know what you're thinking. I don't look much like a doctor, do I? No white coat, no stethoscope, you know, the thing he used to listen to your heart, and most importantly, no gorgeous doctor's assistant!'[paragraph break]The boy's expression remains blank. Is it possible that he has never been to a doctor?[remove doctors tell suggestion][add doctors ask suggestion]".

Response of the boy when asked about doctors during first chapter:
	if doctors is listed in ask-suggestions of the boy:
		say "'Have you ever been to a doctor, boy?'[paragraph break]'No, sir.' The boy earnestly shakes his head. 'Mum says that the old doc died before I was born. There is no doctor in New Haven now, sir.'[remove doctors ask suggestion][add new haven ask suggestion]";
	otherwise:
		say "I don't have any questions about that right now.".

Response of the boy when asked about New Haven during first chapter:
	say "'Hm.'" [TODO]

Response of the boy when asked about reason for his visit during first chapter:
	say "[one of]I stare at the boy somewhat sternly. 'This is not a very hospitable place, and nobody lives near here. You came here with a reason, right?'[paragraph break]'Yes, sir,' comes his hesitating answer. 'I came here to ask for your help, sir. Please... will you help us?'[remove reason for his visit ask suggestion][add the 'us' he mentioned ask suggestion][add help ask suggestion][add not calling me sir tell suggestion][or]I had better ask for something more specific.[stopping]".

not calling me sir is a familiar thing. [not calling me sir]

Response of the boy when told about not calling me sir:
	say "I briefly consider telling the boy that he should stop calling me 'sir', but the response is all too easy to predict.[remove not calling me sir tell suggestion]".

There is a familiar person called the 'us' he mentioned. [the 'us' he mentioned]

Response of the boy when asked about the 'us' he mentioned:
	say "'This 'us' you mention, boy--who's that? Who is it you want me to help?'[paragraph break]'All of us, sir!'[paragraph break]'Yes, but who [italic type]is[roman type] that? Your family? Your town? The sentient species living within two hundred kiloparsec of Betelgeuse?'[paragraph break]'All of us in New Haven, sir. And maybe also the other places I've seen?'[remove the 'us' he mentioned ask suggestion]".

help is a familiar thing. [help]


The boy-doing-here-node is a convnode.





Chapter - First attack - Raven

Every turn when the medicine given boolean has been true for exactly three turns:
	say "With a crash of cracking glass something [bold type]bursts[roman type] through the window! I duck just in time as it launches itself towards my head--it's a big raven, and one that seems to be after my blood.";
	now the current feeling is excited;
	now the task at hand is killing the raven;
	reset the interlocutor; [TODO - this doesn't work?]
	move the raven to the cabin.

The raven is a monster. "[if the raven is alive]A bloodthirsty raven sweeps and dives through the room[otherwise]A dead raven lies on the floor[end if]." The defence of the raven is 4. The melee of the raven is -1. The health of the raven is 5.

Instead of examining the raven:
	say "[if the raven is alive]A wild flurry of black feathers, sharp talons and what seem to be several large beaks--although on calmer consideration it's doubtful that the raven is endowed with more than one of them[otherwise]Dead, the raven is lot less impressive. And more revolting[end if].".

A standard AI action select rule (this is the raven AI rule):
	if the global attacker is the raven begin;
		choose row with an Option of the action of the global attacker attacking the global defender in the Table of AI Combat Options;
		increase the Weight entry by 2;
		choose a Row with Option of the action of the global attacker parrying in the Table of AI Combat Options;
		decrease the Weight entry by 10;
	end if.


[flavour, fatal player flavour, fatal flavour, attack move flavour]

An attack move flavour rule (this is the raven attack move flavour rule):
	if the global attacker is the raven begin;
		say "[one of]Letting out a shrill, piercing cry, the raven dives towards [possessive of the global defender] head.[or]The vicious bird swoops in for another attack.[or]Once again the raven comes at [the global defender dobj], with the obvious intent of picking out [possessive of the global defender] eyes with its sharp beak.[or]Its sharp claws gleam in the lamplight as the raven launches itself towards [the global defender dobj].[at random]";
		rule succeeds; [Otherwise we get a double message.]
	end if.


A flavour rule (this is the raven attacks flavour rule):
	if the global attacker is the raven begin;
		if the final damage is greater than 0 begin;
			let N be a random number between 1 and 5;
			if N is 1, say "The raven buries its sharp claws in [possessive of the global defender] [one of]right[or]left[purely at random] arm, leaving bloody gashes as it flies away again.[run paragraph on]";
			if N is 2, say "The raven picks a chunk of flesh from [possessive of the global defender] [one of]shoulder[or]leg[or]neck[or]thigh[purely at random].[run paragraph on]";
			if N is 3, say "Madly flapping its wings into your face, the raven nearly beats [the global defender dobj] into insensibility.[run paragraph on]";
			if N is 4, say "The raven nearly manages to pick out one of [possessive of the global defender] eyes, but finally has to content itself with biting hard into [possessive of the global defender] [one of]cheek[or]nose[or]eyelid[or]ear[purely at random].[run paragraph on]";
			if N is 5, say "Dashing from this side to that, the raven appears to be everywhere around [the global defender dobj]. It leaves bloody scratches all over [possessive of the global defender] body.[run paragraph on]";
			say when wounded;
		otherwise;
			let N be a random number between 1 and 5;
			if N is 1, say "The raven attempts to dive bomb into [possessive of the global defender] head, but [the global defender sub] duck[-s] out of the way just in time.[run paragraph on]";
			if N is 2, say "The raven wildly dashes to and fro, but finds no gap in [possessive of the global defender] defences.[run paragraph on]";
			if N is 3, say "Cawing maliciously and with its sharp talons stretched out in anticipation, the raven launches an assault--but [the global defender sub] [one of]easily[or]gracefully[or]smartly[at random] sidestep[-s] the attack.[run paragraph on]";
			if N is 4, say "The raven manages to land several blows with its beak, but none pierce [possessive of the global defender] skin. [The global defender sub] laugh[-s].[run paragraph on]";
			if N is 5, say "As it dives in for [one of][or]another[stopping] attack, [the global defender sub] manag[e-s] to brush aside the raven without any trouble.[run paragraph on]";
		end if;
		rule succeeds;
	end if.

A fatal player flavour rule (this is the raven player flavour rule):
	say "Graceless and humiliated, I fall to the floor as the raven's sharps beak enters my brain through the socket of my left eye. Forgetting about the boy's presence, I shout the foulest oaths I know--but they have neither more nor less magic than any other word. [bold type](A note from the author: you really should not die in this first encounter. Please restart the game and type 'help' in order to learn how the combat system works.)[roman type]".

A fatal flavour rule (this is the raven fatal flavour rule):
	say "'Never attack your betters, thing of evil!' I shout joyously as I [if the black sword is readied]drive my sword through the raven's small body[otherwise]catch the raven and sharply twist its neck[end if], [bold type]killing it[roman type]. 'Whether Tempter sent or tempest tossed...'--but even as I speak the words I am overcome by revulsion for the dead thing. Joy turns to ashes in my--no, that's a vile phrase. Like 'beautified'. Vile.[paragraph break]I feel tired.[run paragraph on]";
	now the current feeling is tired;
	now the task at hand is who knows?;
	record "killing the raven" as achieved;
	now the fever boolean is false;
	rule succeeds.



Test sub1 with "x me / x boy / x sundries / open teapot / take medicine / look under table / give medicine to boy / look under bed / give beer to boy / z / z / z / x raven"





